//Evaluation of effect of Pole location on stability of II order system
s=%s;
t=0:0.001:20;
wn=1;

//Poles on -ve real axis(zeta>1)
zeta=2 ;
R=roots(s^2 + 2*zeta*wn*s + wn^2)  // R(1) = - 3.7320508 , R(2) = - 0.2679492 
T=syslin('c',wn^2,(s-R(1))*(s-R(2)))//T=syslin('c',wn^2,s^2 + 2*zeta*wn*s + wn^2);
Ts1=csim('step',t,T);
subplot(231)
xtitle("Poles on -ve Real axis (zeta>1)")
plot(t,Ts1);
xgrid;

//Equal Poles on -ve Real axis (zeta=1)
zeta=1 ;
R=roots(s^2 + 2*zeta*wn*s + wn^2)  // R(1) = R(2) = -1
T=syslin('c',wn^2,(s-R(1))*(s-R(2)))//T=syslin('c',wn^2,s^2 + 2*zeta*wn*s + wn^2);
Ts1=csim('step',t,T);
subplot(232)
xtitle("Equal Poles on -ve Real axis (zeta=1)")
plot(t,Ts1);
xgrid;

//Complex conjugate Poles with -ve Real part (0<zeta<1)
zeta=0.5 ;
R=roots(s^2 + 2*zeta*wn*s + wn^2) // R(1)= -0.5 +0.8660254i, R(2)= -0.5 -0.8660254i
T=syslin('c',wn^2,(s-R(1))*(s-R(2)))//T=syslin('c',wn^2,s^2 + 2*zeta*wn*s + wn^2);
Ts1=csim('step',t,T);
subplot(233)
xtitle("Complex conj Poles with -ve Real part (0<zeta<1)")
plot(t,Ts1);
xgrid;

//Complex conj Poles on Imag axis (zeta=0)
zeta=0 ;
R=roots(s^2 + 2*zeta*wn*s + wn^2)  // R(1)= i, R(2) = -i
T=syslin('c',wn^2,(s-R(1))*(s-R(2)))//T=syslin('c',wn^2,s^2 + 2*zeta*wn*s + wn^2);
Ts1=csim('step',t,T);
subplot(234)
xtitle("Complex conj Poles on Imag axis (zeta=0)")
plot(t,Ts1);
xgrid;

//Complex conj Poles with +ve Real part (0>zeta>-1)
zeta=-0.5 ;
R=roots(s^2 + 2*zeta*wn*s + wn^2)  // R(1)= 0.5 + 0.8660254i, R(2) = 0.5 - 0.8660254i
T=syslin('c',wn^2,(s-R(1))*(s-R(2)))//T=syslin('c',wn^2,s^2 + 2*zeta*wn*s + wn^2);
Ts1=csim('step',t,T);
subplot(235)
xtitle("Complex conj Poles with +ve Real part (0>zeta>-1)")
plot(t,Ts1);
xgrid;

//Poles on +ve Real axis (zeta<-1)
zeta=-1.2 ;
R=roots(s^2 + 2*zeta*wn*s + wn^2)  // R(1)= 5.8284271, R(2) = 0.1715729
T=syslin('c',wn^2,(s-R(1))*(s-R(2)))//T=syslin('c',wn^2,s^2 + 2*zeta*wn*s + wn^2);
Ts1=csim('step',t,T);
subplot(236)
xtitle("Poles on +ve Real axis (zeta<-1)")
plot(t,Ts1);
xgrid;

